import numpy as np
import matplotlib.pyplot as plt
width = 0.5

colum1 = [0.5011547488525601, 0.4949493555845389, 0.48963178977456573, 0.5024954856836028, 0.49975805679882257, 0.4965045403850893, 0.49667393950839617, 0.49616505053449467, 0.49485301177825863, 0.48967294813579154, 0.49672611921226073, 0.49356549821724066, 0.49959701892477976, 0.4926780692766814, 0.4961190544056135]

colum2 = [0.4971040881724898, 0.49166769940360605, 0.499606631242465, 0.4983400643896603, 0.49544562401327197, 0.49468126911897436, 0.49982894052986937, 0.5022240483419965, 0.5036070622655917, 0.4968004849617522, 0.49697138349865294, 0.49085258342015786, 0.4999654981662751, 0.4977303500317931, 0.5006497672300482]

colum3 = [0.49697349713339367, 0.502066508330624, 0.49772208443542243, 0.4984153446799143, 0.4987651093380531, 0.5016725152889583, 0.5014714301967077, 0.49586388631385797, 0.499243212076636, 0.49790264185724387, 0.5001261429670014, 0.5003584864398165, 0.4959978256755167, 0.49958841995689685, 0.5000536987120717]

colum4 = [0.5024447033461727, 0.5000551674336885, 0.5017462854708313, 0.49825584419538826, 0.502617319981295, 0.504025440853457, 0.5000827357084902, 0.5017704223511606, 0.4964706041014324, 0.4969048430723055, 0.4967930148577093, 0.4985431967191975, 0.5005861681631709, 0.5009656672236603, 0.48555567448328346]

colum = [colum1,colum2,colum3,colum4]
btm = [0.4711324865405187, 0.475, 0.4776393202250021, 0.47958758547680685]

labels = ['300', '400', '500', '600']
x = np.arange(len(labels))

fig, ax = plt.subplots()
size = 12
ax.tick_params(axis='both', which='major', labelsize=size)
ax.tick_params(axis='both', which='minor', labelsize=size)
plt.rc('font', size=size)
plt.rc('axes', titlesize=size)
plt.rc('axes', labelsize=size)
plt.rc('xtick', labelsize=10)
plt.rc('ytick', labelsize=size)
plt.rc('legend', fontsize=14)
plt.rc('figure', titlesize=size)
ax.bar(x, btm, width, label="Theoretical", edgecolor='k', color = '#929591')

for i in range(15):
    scy = []
    for j in x:
        scy.append(colum[j][i])
    if i == 0:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1, label="Experimental")
    else:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1)
ax.bar(x, 1, width, edgecolor='k', zorder=0, color = '#FAC205')
ax.set_ylabel(r"$\mathbb{E}\left[ALG\right]$ / $\max$ OPT", fontsize=18)
ax.set_xlabel(r"$\ K$", fontsize=18)
ax.set_xticks(x)
ax.set_xticklabels(labels)
ax.legend(ncol=3, loc='lower center', bbox_to_anchor=(0.5, 1))
ax.set_ylim(0.35, 0.53)

plt.rcParams["font.family"] = "Times New Roman"
plt.rc('pdf',fonttype = 42)
plt.rc('ps',fonttype = 42)
plt.style.use('classic')
plt.tight_layout()
figure = plt.gcf()
figure.savefig("Set1-1.pdf")
plt.show()